unit Unit1;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, process, Forms, Controls, Graphics, Dialogs, StdCtrls,
  ExtCtrls;

type

  { TForm1 }

  TForm1 = class(TForm)
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Process1: TProcess;
    Process2: TProcess;
    Timer1: TTimer;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
  private

  public

  end;

var
  Form1: TForm1;

implementation

{$R *.lfm}

{ TForm1 }


const message:string='';
          VID:integer=-1;
          PID:integer=-1;



procedure TForm1.Button1Click(Sender: TObject);
begin
  Process2.Executable:='pkexec';
  Process2.Parameters.Clear;
  Process2.Parameters.Add(Paramstr(0));                              // launch self, as a console app, with elevated privileges
  Process2.Parameters.Add('0x'+IntToHex(VID,4));
  Process2.Parameters.Add('0x'+IntToHex(PID,4));                     // pass VID and PID as parameters

  Process2.Execute                                                   // (will remove rule file if not a valid VID:PID pair)
end;

procedure TForm1.Button2Click(Sender: TObject);
var username:string;
begin
  username:=GetEnvironmentVariable('USER');
  writeln('adding <', username, '> to plugdev group');
  writeln;

  Process2.Executable:='pkexec';
  Process2.Parameters.Clear;                   // adduser $USER plugdev
  Process2.Parameters.Add('usermod');          // usermod -a -G plugdev $USER
  Process2.Parameters.Add('-a');
  Process2.Parameters.Add('-G');
  Process2.Parameters.Add('plugdev');
  Process2.Parameters.Add(username);

  Process2.Execute
end;

procedure TForm1.Button3Click(Sender: TObject);
var username:string;
begin
  username:=GetEnvironmentVariable('USER');
  writeln('adding <', username, '> to dialout group');
  writeln;

  Process2.Executable:='pkexec';
  Process2.Parameters.Clear;                   // adduser $USER dialout
  Process2.Parameters.Add('usermod');          // usermod -a -G dialout $USER
  Process2.Parameters.Add('-a');
  Process2.Parameters.Add('-G');
  Process2.Parameters.Add('dialout');
  Process2.Parameters.Add(username);

  Process2.Execute
end;



procedure TForm1.FormActivate(Sender: TObject);
const initial:boolean=true;
begin
  if initial then                                                      // just started up --> start dmesg process
  begin
    initial:=false;
    Process1.Execute;
    sleep(100);                                                        // wait 100ms to allow dmesg to start up and begin producing output
    with Process1.Output do while NumBytesAvailable<>0 do ReadByte     // delete all output until silence --> showing only new events
  end
end;



procedure TForm1.Timer1Timer(Sender: TObject);
const mark:int64=0;
      flag:boolean=true;
var buffer:string[127];
     I,J,K:integer;
begin
  label3.Visible:=Process1.Running and odd (GetTickCount64 div 250);
  if flag then if (VID=-1) or (PID=-1) then Button1.Caption:='erase existing rule'
                                       else Button1.Caption:='update rule for vid : pid';
  flag:=false;

  if Process1.Running then                                             // dmesg process is running...
  if Process1.Output.NumBytesAvailable<>0 then                         // there are characters waiting in the queue...
  begin
    if GetTickCount64-mark>300 then begin message:=''; writeln; writeln end;
    mark:=GetTickCount64;                                              // 300ms of silence -> clear message string

    buffer:='';                                                        // needed to suppress compiler warning
    I:=Process1.Output.Read(buffer[1], 127);                           // grab output (part lines possible)
    buffer[0]:=chr(I);
    message:=message+buffer;                                           // copy to end of message string
    write(buffer);                                                     // display dmesg output on terminal

    J:=pos('idVendor=',  message);                                     // look for VID marker
    K:=pos('idProduct=', message);                                     // look for PID marker

    if (J<>0) and (K<>0) then
    begin
      flag:=true;                                                      // signal to update Button1.Caption
      try
        J:=StrToInt('0x'+copy(message, J+ 9, 4));                      // try to extract VID (raises exception on error)
        K:=StrToInt('0x'+copy(message, K+10, 4));                      // try to extract PID (raises exception on error)
        Label1.Caption:='vid = 0x'+IntToHex(J,4);
        Label2.Caption:='pid = 0x'+IntToHex(K,4);
        VID:=J;                                                        // OK --> update VID
        PID:=K                                                         // OK --> update PID
      except
        Label1.Caption:='vid = 0x0000';                                // failed --> return to defaults
        Label2.Caption:='pid = 0x0000';
        VID:=-1;
        PID:=-1
      end
    end
  end
end;



end.

